/*
 * Decompiled with CFR 0.152.
 */
package com.memorysettings;

import com.memorysettings.config.Configuration;
import com.sun.management.OperatingSystemMXBean;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.management.ManagementFactory;
import java.util.Locale;
import java.util.Random;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MemorysettingsMod
implements ModInitializer {
    public static final String MODID = "memorysettings";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String DISABLE_WARNING_BUTTON = "Stop showing";
    public static Configuration config = new Configuration();
    public static Random rand = new Random();

    public void onInitialize() {
    }

    public static void checkMemory() {
        config = new Configuration();
        config.load();
        if (MemorysettingsMod.config.getCommonConfig().disableWarnings) {
            return;
        }
        int systemMemory = (int)(((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize() / 0x100000L);
        int freeMemory = (int)(((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getFreePhysicalMemorySize() / 0x100000L);
        int heapSetting = (int)(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() / 0x100000L);
        if (System.getProperties().getProperty("sun.arch.data.model").equals("32") && systemMemory > 4096) {
            MemorysettingsMod.message("You're using 32bit java on a 64bit system, please install 64bit java.");
            return;
        }
        int configMax = FabricLoader.getInstance().getEnvironmentType() != EnvType.SERVER ? MemorysettingsMod.config.getCommonConfig().maximumClient : MemorysettingsMod.config.getCommonConfig().maximumServer;
        int configMin = FabricLoader.getInstance().getEnvironmentType() != EnvType.SERVER ? MemorysettingsMod.config.getCommonConfig().minimumClient : MemorysettingsMod.config.getCommonConfig().minimumServer;
        int recommendMemory = (int)Math.min((double)systemMemory * 0.7 * 0.8, Math.max((double)configMin, Math.min((double)configMax, (double)freeMemory * 0.8)));
        Object message = "";
        if (heapSetting > configMax) {
            message = (String)message + "You have more memory allocated(" + heapSetting + "mb) than recommended for this pack, the maximum is: " + configMax + "mb.\nThe recommended amount for your system is: " + recommendMemory + " mb.\n";
        }
        if (heapSetting < configMin) {
            message = (String)message + "You have less memory allocated(" + heapSetting + "mb) than recommended for this pack, the minimum is: " + MemorysettingsMod.config.getCommonConfig().minimumClient + "mb.\nThe recommended amount for your system is: " + recommendMemory + " mb.\n";
        }
        if (heapSetting > recommendMemory + 523) {
            message = (String)message + "You have more memory allocated than recommended for your system, the recommended amount for your system is: " + recommendMemory + " mb.\n";
        }
        if (recommendMemory < configMin) {
            message = (String)message + "The recommended for your system is lower than the required minimum of " + MemorysettingsMod.config.getCommonConfig().minimumClient + "mb for this pack, things may not work out so well.\nMost common sign of insufficient ram is frequent stutters.\n";
        }
        if (((String)message).equals("")) {
            return;
        }
        MemorysettingsMod.message((String)message);
    }

    private static void message(String s) {
        try {
            if (FabricLoader.getInstance().getEnvironmentType() != EnvType.SERVER) {
                String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
                if (OS.contains("mac") || OS.contains("darwin")) {
                    MemorysettingsMod.openMessageUI(s);
                } else {
                    SwingUtilities.invokeLater(() -> MemorysettingsMod.openMessageUI(s));
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error during showing memory warning GUI:", (Throwable)e);
        }
        LOGGER.error(s);
    }

    private static void openMessageUI(String s) {
        Object[] options = new String[]{"Ok", DISABLE_WARNING_BUTTON};
        final JFrame jf = new JFrame("Memory Settings");
        jf.setResizable(false);
        jf.setAlwaysOnTop(true);
        JPanel panel = new JPanel();
        jf.setContentPane(panel);
        JLabel label = new JLabel();
        Font font = label.getFont();
        StringBuffer style = new StringBuffer("font-family:" + font.getFamily() + ";");
        style.append("font-weight:" + (font.isBold() ? "bold" : "normal") + ";");
        style.append("font-size:" + font.getSize() + "pt;");
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(s);
        optionPane.setOptions(options);
        optionPane.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue().equals(MemorysettingsMod.DISABLE_WARNING_BUTTON)) {
                    MemorysettingsMod.config.getCommonConfig().disableWarnings = true;
                    config.save();
                }
                jf.dispose();
            }
        });
        JEditorPane ep = new JEditorPane("text/html", "");
        panel.add((Component)optionPane, "Center");
        optionPane.add((Component)ep, "Center");
        ep.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        ep.setEditable(false);
        ep.setText("<html><body style=\"" + style + "\">" + MemorysettingsMod.config.getCommonConfig().helpfullinkmessage + "</body></html>");
        ep.addHyperlinkListener(event -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    Desktop.getDesktop().browse(event.getURL().toURI());
                }
                catch (Exception ex) {
                    LOGGER.warn("error:", (Throwable)ex);
                }
            }
        });
        jf.setSize(new Dimension(Math.max(jf.getPreferredSize().width, ep.getPreferredSize().width), jf.getPreferredSize().height + ep.getPreferredSize().height));
        jf.setLocationRelativeTo(null);
        jf.setVisible(true);
        Object selectedValue = optionPane.getValue();
        jf.setDefaultCloseOperation(2);
        jf.pack();
        if (selectedValue instanceof String && selectedValue.equals(DISABLE_WARNING_BUTTON)) {
            MemorysettingsMod.config.getCommonConfig().disableWarnings = true;
            config.save();
        }
    }
}

